// Scout Tool Sample Program 1:  Motors back and forth.
// Copyright The LEGO Company - November 18, 1999

// Description: Runs the motors A and B forward for 5 seconds 
// and backward for 5 seconds.

// Requires "scoutdef.h" for shortcut commands like on, rwd, fwd.
// See Scout SDK documentation for formal assembler commands.

// Program:

#include "ScoutDef.h"

dels                          //  deletes all subroutines from memory
delt                           // deletes all tasks from memory

task 0                       // start of Task 0 (the first task in the Scout)
     plays 6                 // play System Sound #6
     fwd 3                   // sets direction of A and B forward (assembler = "dir 2,3")  
     on 3                     // on AB (assembler = "out 2,3")
     wait 2,500            //  waits 500 100ths of a seconds = 5 seconds)
     plays 6
     rwd 3                    // set direction of A and B backward (assembler = "dir 0,3")  
     wait 2,500 
     plays 2                  // play System Sound #2
endt                           // end of Task 0



