// Scout Tool Sample Program 2: Looping a sequence.
// Copyright The LEGO Company - November 18, 1999

// Description: Plays a beep and flashes the light on and off ten times.

// Requires "scoutdef.h" for shortcut commands like on, rwd, fwd.
// See Scout SDK documentation for formal assembler commands.

// Program:

#include "ScoutDef.h"

dels                         // Deletes all subroutines from memory
delt                         // Deletes all tasks from memory

#define Counter 10         // assigns the name "Counter" to a local variable #10

task 0                              // start of Task 0 (the first task in the Scout)
     plays 3                        // plays System Sound #3 to signal start of program
     wait 2,100                   // waits 1 second
     setv Counter,2,10       // sets the Counter to a constant value of 10
loop:                                 // start of loop
     decvjn Counter,endloop 
                                         // decrement (subtract) 1 from the counter
                                         // jumps to "endloop" when the counter reaches below 0  
     plays 6                         // plays System Sound #6 at the beginning of each iteration
     light 1                           // turns the Scout's red light on
     wait 2,50                      // waits .5 seconds
     light 0                           // turns the Scout's red light off
     wait 2,50                      // waits .5 seconds  
     jmp loop                       // return to start of loop
endloop:                           // end of loop jump point
     plays 2                         // plays System Sound #2 to signal end of program
endt                                  // end of Task 0
 





