// Scout Tool Sample Program 3:  Back where we started.
// Copyright The LEGO Company - November 18, 1999

// Description: Drives forward until touch and then drives backward for 
// the same amount of time to return to starting point.

// Requires "scoutdef.h" for shortcut commands like on, rwd, fwd.
// See Scout SDK documentation for formal assembler commands.

// Program:

#include "ScoutDef.h"

dels                          //  deletes all subroutines from memory
delt                           // deletes all tasks from memory


// Assigns the names "i", "P0", "P1", and "DrivingTime" to a global variables 0, 1, 2, and 4

#define i 0
#define P0 1
#define P1 2
#define DrivingTime 4

task 0                        // Start of Task 0 (the first task in the Scout)

// Step 1: Timer starts as the rover starts driving forward.

     tmrs TIMER_1,2,32767  
                  // sets the Timer to a maximum limit and resets
                 // the Timer to start counting from zero
//     wait 2,100          // waits 1 second
//     tmrz TIMER_1                 //   
     fwd 3                  // set direction forward for AB
     on 3                    // on AB 

// Step 2:  Rover continues until one of the touch sensors is pressed

     mone 2, EVENT_T1PR | EVENT_T2PR, endWait1  
                         // " mone" starts a monitor for touch 1 or touch 2 press event
                         // jumps to "endWait1" label when the event is triggered
wait1:               // start of wait1 loop
     jmp wait1     // jumps to label "wait1" to repeat the loop   
endWait1:        // jump point for when event monitor breaks out of the "wait1" loop 

// Step 3:  Timer value is recorded   

     setv DrivingTime, SRC_TIMER,TIMER_1    
       // Sets the variable "DrivingTime" equal to the Timer's value at the point
       // one of the touch sensors was pressed.  

// Step 4:  Timer is restarted
    
     tmrs TIMER_1, SRC_VAR,DrivingTime
       // Restarts the Timer and sets its limit equal to "DrivingTime."
       // This will generate a timer event when the limit is reached.

// Step 5:  Rover starts driving backward.

	rwd 3           // set direction backward for AB            
	plays 6         // plays System Sound #6
	on 3            // on AB

// Step 6:  Rover stops when it has driven back for the same 
//              amount of time it had gone forward.

	mone 2, EVENT_TMR1, endWait2
                         // " mone" starts a monitor for Timer 1
                         // jumps to "endWait2" label when Timer 1 limit is reached

	wait2:
		jmp		wait2
	endWait2:

	off 3              // turns AB off (should stop at same place Scout started)
	plays 2             // plays System Sound #2 to signal the end of the program
endt                        // End of Task 1
